from calibre.web.feeds.news import BasicNewsRecipe

class Metro_Montreal(BasicNewsRecipe):

    title          = u'M\xe9tro Montr\xe9al'
    __author__     = 'Jerry Clapperton'
    description    = 'Le quotidien le plus branch sur le monde'
    language       = 'fr'

    oldest_article        = 7
    max_articles_per_feed = 20
    use_embedded_content  = False
    remove_javascript     = True
    no_stylesheets        = True
    encoding              = 'utf-8'
    extra_css             = '.headline {font-size: x-large;} \n .fact {padding-top: 10pt}'

    remove_tags = [dict(attrs={'id':'buttons'})]
    
    feeds = [
             (u"L'info", u'http://journalmetro.com/linfo/rss'),
             (u'Monde', u'http://journalmetro.com/monde/rss'),
             (u'Culture', u'http://journalmetro.com/culture/rss'),
             (u'Sports', u'http://journalmetro.com/sports/rss'),
             (u'Paroles', u'http://journalmetro.com/paroles/rss')
            ]

    def print_version(self, url):
          return url.replace('article', 'ArticlePrint') + '?language=fr'